/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.anims;

import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class YoimiyaSAAnimation
extends AttackAnimation {
    public YoimiyaSAAnimation(float convertTime, float antic, float recovery, InteractionHand hand, @Nullable Collider collider, Joint scanner, String path, Armature model) {
        super(convertTime, path, model, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, 0.0f, antic, recovery, Float.MAX_VALUE, hand, scanner, collider)});
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true);
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        JointTransform jt = pose.getOrDefaultTransform("Root");
        Vec3f jointPosition = jt.translation();
        OpenMatrix4f toRootTransformApplied = entitypatch.getArmature().searchJointByName("Root").getLocalTrasnform().removeTranslation();
        OpenMatrix4f toOrigin = OpenMatrix4f.invert((OpenMatrix4f)toRootTransformApplied, (OpenMatrix4f)null);
        Vec3f worldPosition = OpenMatrix4f.transform3v((OpenMatrix4f)toRootTransformApplied, (Vec3f)jointPosition, (Vec3f)null);
        worldPosition.x = 0.0f;
        worldPosition.y = 0.0f;
        worldPosition.z = 0.0f;
        OpenMatrix4f.transform3v((OpenMatrix4f)toOrigin, (Vec3f)worldPosition, (Vec3f)worldPosition);
        jointPosition.x = worldPosition.x;
        jointPosition.y = worldPosition.y;
        jointPosition.z = worldPosition.z;
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, DynamicAnimation dynamicAnimation) {
        ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, 0.0, 0.0);
        ((LivingEntity)entitypatch.getOriginal()).m_20242_(true);
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        ((LivingEntity)entitypatch.getOriginal()).m_20242_(false);
        return vec3.m_82542_(1.0, 2.0, 1.0);
    }

    protected void attackTick(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this);
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entitypatch, elapsedTime);
        EntityState prevState = this.getState(entitypatch, prevElapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
        if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
            ((Mob)entitypatch.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
            LivingEntity target = entitypatch.getTarget();
            if (target != null) {
                entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
            }
        }
        if ((prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) && (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2))) {
            entitypatch.getCurrenltyAttackedEntities().clear();
        }
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }
}

